create or replace package tbicds.PCK_REPORTS_PAT
AUTHID CURRENT_USER 
is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
 type RetRefCursor is ref cursor;


 procedure GetTrendBaseRS( pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_vPatientID       in varchar2,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out RetRefCursor);
                           
function GetPrevIntakeScore(pi_nMID in number,
                            pi_vPatientID in varchar2,
                            pi_nIntakeID in number)
  
 return number;
 
function GetCurrentIntakeScore(pi_vPatientID in varchar2,
                               pi_nMID in number)
  
 return number;
 
procedure GetNoteDatesRS( pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vPatientID       in varchar2,
                          pi_dtFrom           in date,
                          pi_dtTo             in date,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor);
                          
procedure GetNoteTextRS( pi_vSessionID       in varchar2,
                         pi_vSessionClientIP in varchar2,
                         pi_nUserID          in number,
                         pi_vPatientID       in varchar2,
                         pi_nPatPWEventID    in number,
                         pi_dtFrom           in date,
                         pi_dtTo             in date,
                         po_nStatusCode      out number,
                         po_vStatusComment   out varchar2,
                         rs                  out RetRefCursor);
                          
procedure GetInstrumentScoreRS( pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vPatientID       in varchar2,
                                pi_nMID             in number,
                                pi_dtFrom           in date,
                                pi_dtTo             in date,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor); 
                                
/*gets all scorable modules for this patient and date range
with the 10 most recent columns nulled out for fill in later*/
procedure GetInstrumentsBaseRS( pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vPatientID       in varchar2,
                                pi_dtFrom           in date,
                                pi_dtTo             in date,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor);
                                
 procedure GetPatPopulationRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vKey             in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor); 
  

end PCK_REPORTS_PAT;
/

